CREATE TABLE `idx_pagerank` (
  `link_id` mediumint(8) unsigned NOT NULL default '0',
  `engine` char(1) NOT NULL default '',
  `rank` tinyint(4) NOT NULL default '0',
  `last_update` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`link_id`,`engine`)
);

CREATE TABLE `idx_custom_field` (
  `field_name` varchar(32) NOT NULL default '',
  `field_text` varchar(64) NOT NULL default '',
  `field_type` enum('TEXT','TEXTAREA','SELECT','MULTISELECT','CHECKBOX','RADIO','FILE','IMAGE','DATE','DATETIME') NOT NULL default 'TEXT',
  `field_option` text NOT NULL,
  `field_img_width` INT(10) unsigned NOT NULL default '0',
  `field_img_height` INT(10) unsigned NOT NULL default '0',
  `field_file_size` INT(10) unsigned NOT NULL default '0',
  `field_file_extension` varchar(64) NOT NULL default '',
  `required` char(1) NOT NULL default '0',
  `searchable` char(1) NOT NULL default '1',
  `permission` char(1) NOT NULL default '0'
);

insert into `idx_invoice_config`
    (company, contact, address, phone, email, currency) values
    ('Your website / Company', 'Billing Department', 'Your address', 'Your phone #', 'Billing<name@yourdomain.com>', '$');

alter table `idx_category` add `basic_price` double unsigned NOT NULL default '0' after `order_num`;
alter table `idx_category` change `premium_price` `premium_price` double unsigned NOT NULL default '0';
alter table `idx_category` change `sponsored_price` `sponsored_price` double unsigned NOT NULL default '0';

alter table `idx_invoice_config` change `currency` `currency_symbol` varchar(255) default '$';
alter table `idx_invoice_config` add `currency_code` varchar(255) default 'USD';

alter table `idx_link` change `suspended` `suspended` char(1) NOT NULL default '0';
alter table `idx_link` change `bid` `bid` smallint(6) NOT NULL default '0';
alter table `idx_link` drop `sp_cat`;
alter table `idx_link` drop `sp_cat_date_limit`;
alter table `idx_link` drop `sp_cat_order`;
alter table `idx_link_temp` change `suspended` `suspended` char(1) NOT NULL default '0';
alter table `idx_link_temp` change `bid` `bid` smallint(6) NOT NULL default '0';
alter table `idx_link_temp` drop `sp_cat`;
alter table `idx_link_temp` drop `sp_cat_date_limit`;
alter table `idx_link_temp` drop `sp_cat_order`;

alter table `idx_users` drop `theme`;
alter table `idx_users` drop `nol_category`;
alter table `idx_users` drop `nol_search`;

drop table `idx_category_in_order`;